/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.blockentity.StoneMillBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import xueluoanping.teastory.block.NormalHorizontalBlock;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class StoneMillBlock
extends NormalHorizontalBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 9.0, 16.0);

    public StoneMillBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6810_(BlockState blockState, Level worldIn, BlockPos pos, BlockState pNewState, boolean isMoving) {
        this.dropItems(worldIn, pos);
        super.m_6810_(blockState, worldIn, pos, pNewState, isMoving);
    }

    private void dropItems(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null) {
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(inv -> {
                for (int i = inv.getSlots() - 1; i >= 0; --i) {
                    if (inv.getStackInSlot(i) == ItemStack.f_41583_) continue;
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                    ((IItemHandlerModifiable)inv).setStackInSlot(i, ItemStack.f_41583_);
                }
            });
            te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(inv -> {
                for (int i = inv.getSlots() - 1; i >= 0; --i) {
                    if (inv.getStackInSlot(i) == ItemStack.f_41583_) continue;
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                    ((IItemHandlerModifiable)inv).setStackInSlot(i, ItemStack.f_41583_);
                }
            });
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_21120_(handIn), (int)1)).isPresent()) {
                return te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_()).map(fluidTank -> {
                    FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)fluidTank);
                    return InteractionResult.SUCCESS;
                }).orElse(InteractionResult.FAIL);
            }
            if (te instanceof StoneMillBlockEntity) {
                if (!player.m_6144_()) {
                    if (!player.m_21120_(handIn).m_41619_()) {
                        return te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).map(container -> {
                            player.m_21008_(handIn, container.insertItem(0, player.m_21120_(handIn), false));
                            return InteractionResult.SUCCESS;
                        }).orElse(InteractionResult.FAIL);
                    }
                    te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(container -> {
                        for (int i = 0; i <= 2; ++i) {
                            ItemStack itemStack = container.extractItem(i, 64, false);
                            if (itemStack.m_41619_()) continue;
                            Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                        }
                    });
                    te.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(container -> {
                        if (((StoneMillBlockEntity)te).isCompleted()) {
                            ItemStack itemStack = container.extractItem(0, container.getStackInSlot(0).m_41613_(), false);
                            Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                        }
                    });
                    return InteractionResult.SUCCESS;
                }
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)te), (BlockPos)te.m_58899_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StoneMillBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        return StoneMillBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityRegister.STONE_MILL_TYPE.get(), StoneMillBlockEntity::tick);
    }
}

